DROP VIEW ADR.ACTIVEAGG_VW;

/* Formatted on 7/25/2019 8:52:52 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.ACTIVEAGG_VW
(
   PERID,
   ICN,
   EDIPI,
   SSN,
   LN,
   FN,
   MN,
   SUF,
   DOB,
   DOD,
   GENDER,
   ENR_DTE,
   CV_ELIG,
   ELIG_VERIFIED,
   ENR_CODE,
   PRIORITY,
   ENR_CRE_DTE,
   ADD_TYPE,
   BAI,
   ADDRESS_ID,
   ST1,
   ST2,
   ST3,
   CITY,
   STATE,
   ZIP,
   ZIP4,
   COUNTRY,
   ADT,
   PFA,
   PCF,
   HPN,
   CPN,
   WPN,
   APN,
   TSTART,
   TEND,
   PF_NO,
   PF_NAME,
   VCE,
   SCI,
   SC_PCT,
   SAI,
   SALIST,
   NSCI,
   NLE_ES,
   STA_VISN,
   STA_NO,
   STA_NAME,
   EE_FLAG,
   DISTANCE,
   OPP_FLAG,
   ADR_LON,
   ADR_LAT,
   STA_ST1,
   STA_ST2,
   STA_ST3,
   STA_CITY,
   STA_STATE,
   STA_ZIP,
   STA_ZIP4,
   STA_LON,
   STA_LAT,
   LOC_NAME,
   GEO_DATE,
   SOFTWARE_VER,
   STATUS,
   STATUS_DATE,
   WT_INFO_CONCATTED,
   MAILING_EXCEPTION,
   TIME_COHORT,
   BASIC_ELIG,
   GEO_TIME_FRAME_BEGIN,
   GEO_TIME_FRAME_END,
   WT_RUN_TIME,
   VBA_DOD,
   EVER_GEO_CODED,
   CALC_TYPE,
   DD_BASIC_ELIG,
   DD_NLE_ES,
   VISN,
   URH,
   FIPS,
   MARKET,
   SUBMARKET,
   SECTOR,
   STATE_FIPS,
   S_CLASS_NAME,
   OUTPATIENTRATING,
   PAR_STA_NO,
   PARENTSTATIONCL,
   SH_PAR_STA,
   VA_SITE,
   ST,
   POD,
   SHAR,
   HCC,
   MSCBOC,
   NEWVAMC,
   PCCBOC,
   COCCLASSIFICATIONID,
   VAH,
   CD,
   CONT,
   PROV,
   VACAA_LIST_DATE,
   NLE_ES_DATE,
   COUNTY_NAME,
   MARKET_NAME,
   DATASOURCE,
   DISTRICT,
   STA_DISTRICT_VISN,
   RECORD_CREATED_TS
)
AS
   SELECT PERID,
          ICN,
          EDIPI,
          SSN,
          LN,
          FN,
          MN,
          SUF,
          DOB,
          DOD,
          GENDER,
          ENR_DTE,
          CV_ELIG,
          ELIG_VERIFIED,
          ENR_CODE,
          PRIORITY,
          ENR_CRE_DTE,
          ADD_TYPE,
          BAI,
          ADDRESS_ID,
          ST1,
          ST2,
          ST3,
          CITY,
          STATE,
          ZIP,
          ZIP4,
          COUNTRY,
          ADT,
          PFA,
          PCF,
          HPN,
          CPN,
          WPN,
          APN,
          TSTART,
          TEND,
          PF_NO,
          PF_NAME,
          VCE,
          SCI,
          SC_PCT,
          SAI,
          SALIST,
          NSCI,
          NLE_ES,
          STA_VISN,
          STA_NO,
          STA_NAME,
          EE_FLAG,
          DISTANCE,
          OPP_FLAG,
          ADR_LON,
          ADR_LAT,
          STA_ST1,
          STA_ST2,
          STA_ST3,
          STA_CITY,
          STA_STATE,
          STA_ZIP,
          STA_ZIP4,
          STA_LON,
          STA_LAT,
          LOC_NAME,
          GEO_DATE,
          SOFTWARE_VER,
          STATUS,
          STATUS_DATE,
          WT_INFO_CONCATTED,
          MAILING_EXCEPTION,
          TIME_COHORT,
          BASIC_ELIG,
          GEO_TIME_FRAME_BEGIN,
          GEO_TIME_FRAME_END,
          WT_RUN_TIME,
          VBA_DOD,
          EVER_GEO_CODED,
          CALC_TYPE,
          DD_BASIC_ELIG,
          DD_NLE_ES,
          VISN,
          URH,
          FIPS,
          MARKET,
          SUBMARKET,
          SECTOR,
          STATE_FIPS,
          S_CLASS_NAME,
          OUTPATIENTRATING,
          PAR_STA_NO,
          PARENTSTATIONCL,
          SH_PAR_STA,
          VA_SITE,
          ST,
          POD,
          SHAR,
          HCC,
          MSCBOC,
          NEWVAMC,
          PCCBOC,
          COCCLASSIFICATIONID,
          VAH,
          CD,
          CONT,
          PROV,
          VACAA_LIST_DATE,
          NLE_ES_DATE,
          COUNTY_NAME,
          MARKET_NAME,
          DATASOURCE,
          DISTRICT,
          STA_DISTRICT_VISN,
          s.RECORD_CREATED_TS
     FROM ADR.ACTIVEAGG s,
          (SELECT CASE
                     WHEN LOADING_STATUS = 'YES' THEN CURRENT_ACTIVE_DATE
                     WHEN LOADING_STATUS = 'FAIL' THEN PREVIOUS_ACTIVE_DATE
                     ELSE NULL
                  END
                     active_dt
             FROM ADR.ActiveAGG_TRACKER) t
    WHERE TRUNC (s.RECORD_CREATED_TS) = TRUNC (t.active_dt);


CREATE OR REPLACE PUBLIC SYNONYM ACTIVEAGG_VW FOR ADR.ACTIVEAGG_VW;


GRANT SELECT ON ADR.ACTIVEAGG_VW TO ADR_R;

GRANT SELECT ON ADR.ACTIVEAGG_VW TO EEATUSR;

GRANT SELECT ON ADR.ACTIVEAGG_VW TO EEUSR;
DROP VIEW ADR.CCN_PERSON_VCE_VW;

/* Formatted on 7/25/2019 8:52:56 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.CCN_PERSON_VCE_VW
(
   PERSON_ID,
   DATE_OF_BIRTH,
   DATE_OF_BIRTH_TXT,
   DEATH_DATE_TXT,
   FIRST_NAME,
   MIDDLE_NAME,
   LAST_NAME,
   SUFFIX,
   GENDER_CODE,
   SSN,
   EDIPI,
   VCELIGIBILITY_H_ID,
   VCELIGBTY_RECORD_MODIFIED_DATE,
   VCE,
   PRIORITY_GROUP,
   PRIORITY_GROUP_EFFECT_DATE_TXT
)
AS
   SELECT /*+  use_hash (per vc t e) parallel(vc, 2) parallel(s, 2) parallel(t, 2) */
         per.PERSON_ID,
          CASE
             WHEN NVL (LENGTH (T.DATE_OF_BIRTH), 1) = 8
             THEN
                TO_DATE (T.DATE_OF_BIRTH, 'YYYYMMDD')
             ELSE
                NULL
          END
             DATE_OF_BIRTH,
          t.DATE_OF_BIRTH DATE_OF_BIRTH_TXT,
          per.DEATH_DATE_TXT,
          t.FIRST_NAME,
          t.MIDDLE_NAME,
          t.LAST_NAME,
          t.SUFFIX,
          t.GENDER_CODE,
          t.ssn,
          t.edipi,
          vc.VCELIGIBILITY_H_ID,
          vc.RECORD_MODIFIED_DATE VCELIGBTY_RECORD_MODIFIED_DATE,
          vc.VCE,
          e.PRIORITY_GROUP,
          e.PRIORITY_GROUP_EFFECT_DATE_TXT
     FROM PERSON per
          INNER JOIN ADR.PERSON_TRAITS t ON t.VPID_VALUE = per.VPID_VALUE
          INNER JOIN
          ADR.CCN_VCELIGIBILITY_H_STG
          PARTITION (CCNVCELIGIBILITY_H_STG_P10) vc
             ON PER.PERSON_ID = vc.PERSON_ID
          INNER JOIN ADR.ENRDETERM_STG PARTITION (ENRDETERM_STG_P10) e
             ON vc.PERSON_ID = e.PERSON_ID;


CREATE OR REPLACE PUBLIC SYNONYM CCN_PERSON_VCE_VW FOR ADR.CCN_PERSON_VCE_VW;


GRANT SELECT ON ADR.CCN_PERSON_VCE_VW TO ADR_R;
DROP VIEW ADR.CCN_REGION_VW;

/* Formatted on 7/25/2019 8:52:57 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.CCN_REGION_VW
(
   CCN_REGION_ID,
   REGION_NAME,
   ISACTIVE,
   EMAIL_GROUP,
   RECORD_CREATED_BY,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_BY,
   RECORD_MODIFIED_DATE,
   RECORD_MODIFIED_COUNT
)
AS
     SELECT CCN_REGION_ID,
            REGION_NAME,
            ISACTIVE,
            EMAIL_GROUP,
            RECORD_CREATED_BY,
            RECORD_CREATED_DATE,
            RECORD_MODIFIED_BY,
            RECORD_MODIFIED_DATE,
            RECORD_MODIFIED_COUNT
       FROM ADR.CCN_REGION
   ORDER BY REGION_NAME ASC;


CREATE OR REPLACE PUBLIC SYNONYM CCN_REGION FOR ADR.CCN_REGION_VW;


GRANT SELECT ON ADR.CCN_REGION_VW TO ADR_R;
DROP VIEW ADR.CCN_SERVICE_LOG_LOAD_VW;

/* Formatted on 7/25/2019 8:52:59 AM (QP5 v5.269.14213.34769) */
CREATE OR REPLACE FORCE VIEW ADR.CCN_SERVICE_LOG_LOAD_VW
(
   SERVICE_LOG_STAT_ID,
   PERSON_ID,
   FIRST_NAME,
   LAST_NAME,
   MID_NAME,
   SUFFIX,
   DATE_OF_BIRTH,
   DATE_OF_BIRTH_TXT,
   DATE_OF_DEATH,
   BIRTH_SEX,
   SSN,
   EDIPI,
   MAILING_ADDRESS_H_ID,
   EMAIL,
   VCELIGIBILITY_H_ID,
   HPHONE_NUM,
   CPHONE_NUM,
   TPHONE_NUM,
   VISN_GEO,
   RESI_ADDRESS_H_ID,
   PREFERRED_FACILITY_H_ID,
   GEOCODE_STATION_H_ID,
   ADDR_RECORD_MODIFIED_DATE,
   VCELIGBTY_RECORD_MODIFIED_DATE,
   SVL_RECORD_MODIFIED_DATE,
   VCE,
   PRIORITY_GROUP,
   PRIORITY_GROUP_EFFECT_DATE_TXT
)
AS
   SELECT /*+ use_hash (per addr prf addrh prf sl) */
          (CASE
              WHEN sl.CCN_SERVICE_LOG_ID IS NULL THEN 0
              WHEN sl.CCN_SERVICE_LOG_ID IS NOT NULL THEN CCN_SERVICE_LOG_ID
           END)
             service_log_stat_id,
          per.person_id,
          per.first_name,
          per.last_name,
          per.middle_name,
          per.suffix,
          per.date_of_birth,
          per.date_of_birth_txt,
          per.death_date_txt,
          per.gender_code,
          per.ssn,
          per.edipi,
          addrh.mailing_address_h_id,
          em.email_address,
          per.VCELIGIBILITY_H_ID,
          ph.hphone_num,
          ph.cphone_num,
          NVL (NVL (ph.tphone_num, addr.address_phone_number),
               tp.address_phone_number),
          geot.visn_geo,
          addrh.resi_address_h_id,
          prf.preferred_facility_h_id,
          geot.GEOCODE_STATION_H_ID,
          addr.addr_record_modified_date,
          per.vceligbty_record_modified_date,
          sl.max_record_modified_date svl_record_modified_date,
          per.VCE,
          per.PRIORITY_GROUP,
          per.PRIORITY_GROUP_EFFECT_DATE_TXT
     FROM ADR.CCN_PERSON_SELECTED_STG PARTITION (CCN_PERSEL_STG_P1) per
          INNER JOIN adr.CCN_ADDRESS_STG PARTITION (CCN_ADDRESS_STG_P1) addr
             ON per.person_id = addr.person_id
          LEFT OUTER JOIN ADR.CCN_ADDRESS_H_STG addrh
             ON addrh.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_PREFERED_FACILITY_H_STG prf
             ON prf.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_EMAIL_STG em
             ON em.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_GEOCODE_TRANSMIT_STG geot
             ON geot.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_PHONE_STG ph
             ON ph.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_TPHONE_STG tp
             ON tp.person_id = per.person_id
          LEFT OUTER JOIN ADR.CCN_SERVLOG_STG sl
             ON sl.person_id || '' = per.person_id;


CREATE OR REPLACE PUBLIC SYNONYM CCN_SERVICE_LOG_LOAD_VW FOR ADR.CCN_SERVICE_LOG_LOAD_VW;


GRANT SELECT ON ADR.CCN_SERVICE_LOG_LOAD_VW TO ADR_R;

GRANT INSERT, SELECT ON ADR.CCN_SERVICE_LOG_LOAD_VW TO ADR_RW;
